#include <struct.h>
#include "LinkedList.h"

//---------------------------------------------
// tools for managing hierarchy
//----------------------------------------------------------------
// Finds position of supplied name in supplied buffer
int findName(const CString* pBuffer, const char* pName, long bufSize)
{
  for (int i = 0; i < bufSize; i++)
    if (!strcmp(pBuffer[i], pName))
      return i;
  return -1;
}


//----------------------------------------------------------------
// Validates list. removes not-found nodes. adds missing nodes
bool ValidateList(char* &pszErrorBuf)
{
  tObjectSet* pObjects = CurrentState.CurrentParams.Objects;
  if (!pObjects)
    return true;

  long numObj = pObjects->ObjAmount;
  if (0 == numObj)
  {
    DeleteList(g_pHList);
    return true;
  }

  CString*  namesBuffer = new CString[numObj];
  BOOL*     bMatched    = new BOOL[numObj];
  int i, pos;
  for (i = 0; i < numObj; i++)
  {
    namesBuffer[i] = CString(pObjects->ObjSet[i].ObjectName);
    bMatched[i] = FALSE;
  }

  //detect duplicates
  for (i = 0; i < numObj; i++)
    for (pos = 0; pos < i; pos++)
      if (namesBuffer[pos] == namesBuffer[i])
      {
        pszErrorBuf = strdup("Duplicate names found. Fix the problem and try again");
        delete[] namesBuffer;
        delete[] bMatched;
        return false;
      }

  //detect loops
  for (i = 0; i < numObj; i++)
  {
    lpNamedRef pRef;
    pos = i;
    bMatched[pos] = TRUE;
    while ((pos != -1) && FindParent(g_pHList, namesBuffer[pos], &pRef) &&
          (pRef->pParent))
    {
      pos = findName(namesBuffer, pRef->pParent, numObj);
      if (pos != -1)
        if (bMatched[pos])
        {
          DeleteRef(g_pHList, pRef);
          pszErrorBuf = strdup("Invalid hierarchy: Loop was detected.");
          delete[] namesBuffer;
          delete[] bMatched;
          return false;
        }
    }
    for (pos = 0; pos < numObj; pos++)
      bMatched[pos] = FALSE;
  }

  //now skim the list
  lpNamedRef ptr = g_pHList;
  while (ptr)
  {
    if (ptr->pParent)
    {
      pos = findName(namesBuffer, ptr->pParent, numObj);
      if (pos == -1)
      {
        free(ptr->pParent);
        ptr->pParent = NULL;
      }
    }
    pos = findName(namesBuffer, ptr->pChild, numObj);
    if (pos == -1)
    {//delete node
      lpNamedRef ptr2 = ptr->pNext;
      DeleteRef(g_pHList, ptr);
      ptr = ptr2;
    }
    else
      bMatched[pos] = TRUE;
    if (pos != -1)//haven't deleted the child
      ptr = ptr->pNext;
  }

  //now add un-matched nodes;
  for (i = 0; i < numObj; i++)
    if (!bMatched[i])
      AddFirst(g_pHList, NULL, namesBuffer[i]);

  delete[] namesBuffer;
  delete[] bMatched;
  return true;
}


//-----------------------------------
// size of chunk, required to store
long RequiredChunkSize()
{
  long size = 8;//trailing guard bytes;
  lpNamedRef ptr = g_pHList;
  while (ptr)
  {
    size+=8;
    if (ptr->pParent)
      size += strlen(ptr->pParent);
    if (ptr->pChild)
      size += strlen(ptr->pChild);
    ptr = ptr->pNext;
  }
  return size;
}


//----------------------------------------------------------------
// Saves hierarchy to the file. Binded with RequiredChunkSize
long Save(CFile* pFile)
{
  char* pstrMessage = NULL;
  if (!ValidateList(pstrMessage))
  {
    free(pstrMessage);
    return 0;
  }
  long  len   = 0;
  DWORD ID    = 0x8020;
  long  size  = RequiredChunkSize();

  pFile->Write(&ID, 4);
  pFile->Write(&size, 4);

  //write the data itself:
  //now ckim the list
  lpNamedRef ptr = g_pHList;
  while (ptr)
  {
    long len = 0;
    if (ptr->pParent)
      len = strlen(ptr->pParent);
    pFile->Write(&len, 4);
    if (ptr->pParent)
      pFile->Write(ptr->pParent, len);
    len = 0;
    if (ptr->pChild)
      len = strlen(ptr->pChild);
    pFile->Write(&len, 4);
    if (ptr->pChild)
      pFile->Write(ptr->pChild, len);
    ptr = ptr->pNext;
  }
  //add 8-byte zero:
  len = 0;
  pFile->Write(&len, 4);
  pFile->Write(&len, 4);
  return size;
}


//----------------------------------------------------------------
// Loads hierarchy from file
long Load(CFile* pFile)
{
  //write the data itself:
  //now ckim the list
  DeleteList(g_pHList);
  char strp[128], strc[128];
  long lenp = 0,lenc = 0, size;
  size = 0;
  for (;;)
  {
    pFile->Read(&lenp, 4);
    if (0!=lenp)
      pFile->Read(strp, lenp);
    strp[lenp] = '\0';
    pFile->Read(&lenc, 4);
    if (0!=lenc)
      pFile->Read(strc, lenc);
    strc[lenc] = '\0';
    size += 8;
    if ((0==lenp) && (0==lenc))
      break;//end
    //add node
    AddLast(g_pHList, strp[0] ? strp : NULL, strc[0] ? strc : NULL);
    size += (lenp+lenc);
  }
  return size;
}

